/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.preferences;

import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.formatter.preferences.Messages;
import com.aptana.formatter.ui.FormatterMessages;
import com.aptana.formatter.ui.IFormatterControlManager;
import com.aptana.formatter.ui.IFormatterModifyDialog;
import com.aptana.formatter.ui.preferences.FormatterModifyTabPage;
import com.aptana.formatter.ui.util.SWTFactory;
import java.net.URL;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class JSFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private static final String INDENTATION_PREVIEW_FILE = "indentation-preview.js";
    private final String[] TAB_OPTION_ITEMS = new String[]{"space", "tab", "mixed", "editor"};
    private final String[] TAB_OPTION_NAMES = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_EDITOR};

    public JSFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.JSFormatterIndentationTabPage_indentationGeneralGroupLabel, (int)2, (int)1, (int)768);
        final Combo tabOptions = manager.createCombo((Composite)group, (Object)"js.formatter.formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.TAB_OPTION_ITEMS, this.TAB_OPTION_NAMES);
        final Text indentationSize = manager.createNumber((Composite)group, "js.formatter.formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size, 1);
        final Text tabSize = manager.createNumber((Composite)group, "js.formatter.formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size, 1);
        tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = tabOptions.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(JSFormatterIndentationTabPage.this.TAB_OPTION_ITEMS[index]))) {
                    indentationSize.setText(tabSize.getText());
                }
            }
        });
        new TabOptionHandler(manager, tabOptions, indentationSize, tabSize);
        group = SWTFactory.createGroup((Composite)parent, (String)Messages.JSFormatterTabPage_indentGroupLabel, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.blocks", Messages.JSFormatterIndentationTabPage_statementsWithinBlocks);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.function.body", Messages.JSFormatterIndentationTabPage_statementsWithinFunctions);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.switch.body", Messages.JSFormatterIndentationTabPage_statementsWithinSwitch);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.case.body", Messages.JSFormatterIndentationTabPage_statementsWithinCase);
        manager.createCheckbox((Composite)group, (Object)"js.formatter.indent.group.body", Messages.JSFormatterIndentationTabPage_statementsWithinJSGroups);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource(INDENTATION_PREVIEW_FILE);
    }

    private class TabOptionHandler
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private IFormatterControlManager manager;
        private Combo tabOptions;
        private Text indentationSize;
        private final Text tabSize;

        public TabOptionHandler(IFormatterControlManager controlManager, Combo tabOptions, Text indentationSize, Text tabSize) {
            this.manager = controlManager;
            this.tabOptions = tabOptions;
            this.indentationSize = indentationSize;
            this.tabSize = tabSize;
            tabOptions.addSelectionListener((SelectionListener)this);
            this.manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = this.tabOptions.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(JSFormatterIndentationTabPage.this.TAB_OPTION_ITEMS[index]);
                boolean editorSettingsMode = "editor".equals(JSFormatterIndentationTabPage.this.TAB_OPTION_ITEMS[index]);
                this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
                this.manager.enableControl((Control)this.tabSize, !editorSettingsMode);
                if (editorSettingsMode) {
                    JSFormatterIndentationTabPage.this.setEditorTabWidth(JSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.tabSize, this.indentationSize});
                }
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"js.formatter.formatter.tabulation.char"));
            boolean editorSettingsMode = "editor".equals(this.manager.getString((Object)"js.formatter.formatter.tabulation.char"));
            this.manager.enableControl((Control)this.indentationSize, !tabMode && !editorSettingsMode);
            this.manager.enableControl((Control)this.tabSize, !editorSettingsMode);
            if (editorSettingsMode) {
                JSFormatterIndentationTabPage.this.setEditorTabWidth(JSPlugin.getDefault().getBundle().getSymbolicName(), new Text[]{this.tabSize, this.indentationSize});
            }
        }
    }
}

